;%COMPLET.sc
;Ŀ
;      TITLE: PercentComplete.u                                              
;     AUTHOR: Paul Alimi                                                     
;    RETURNS: No value                                                       
;    CREATED: 5/28/91                                                        
;DESCRIPTION: Shows user a continuously updated status of a looping          
;             operation - more informative than the traditional              
;             WORKING... message (comments, improvements, etc. welcome)      
;

PROC PercentComplete.u(prompt.a,current.s,total.s)
       ;prompt.a                   prompt
       ;current.s                  iteration currently being processed
       ;total.s                    total iterations to complete task,
       ;                           for example NRECORDS("ANSWER")
PRIVATE lenprompt.s,              ;length of prompt, but minimum of 29
        lentotal.s                ;total length (length of prompt + 21)

lenprompt.s = MAX(LEN(prompt.a),29)
lentotal.s = lenprompt.s +21

IF current.s = 1 THEN             ;do this first time thru only
  PAINTCANVAS ATTRIBUTE 8         ;shadow
  12,INT(((80-lentotal.s)/2)+1),15,INT(((80-lentotal.s)/2)+lentotal.s+3)
  STYLE ATTRIBUTE 31              ;rest of display white on blue
  @11,INT(((80-lentotal.s)/2)-2)??"",FILL("",lentotal.s),"ͻ"
  @12,INT(((80-lentotal.s)/2)-2)??" ",prompt.a,"...",
                   SPACES(lenprompt.s-LEN(prompt.a)+3),
                   FORMAT("w4,ar",current.s/total.s*100)," % Complete "
  @13,INT(((80-lentotal.s)/2)-2)??" ",
                   FILL("",ROUND(current.s/total.s*lentotal.s,0)),
                   FILL("",lentotal.s-ROUND(current.s/total.s*lentotal.s,0))," "
  @14,INT(((80-lentotal.s)/2)-2)??"",FILL("",lentotal.s),"ͼ"
  STYLE                          ;return style to normal
ELSE                             ;only do changes after the first time thru
  STYLE ATTRIBUTE 31             ;white on blue
  @12,INT(((80-lentotal.s)/2)+lenprompt.s+6)??FORMAT("w4,ar",current.s/total.s*100)
  @13,INT((80-lentotal.s)/2)??FILL("",ROUND(current.s/total.s*lentotal.s,0))
  STYLE                          ;return style to normal
ENDIF

ENDPROC

FOR n FROM 1 TO 175               ;sample this in a FOR loop
  PercentComplete.u("Demo Display",n,175)
  SLEEP 100
ENDFOR                            ;What do you think?
